#ifndef _THREAD_H
#define _THREAD_H

typedef struct advstruct
{
	struct advstruct *next;
	int num;
	char descr[100];
	char author[80];
	char rating[20];
	char flags[20];
	char dir[40];
} ADV;

typedef struct eventstruct
{
	struct eventstruct *next;
	void *source;
	char text[200];
} EVENT;


class THREAD : public ParserIO
{
public:
	THREAD();
	virtual ~THREAD();
	void add_event(char *s);
	int catchup();
	int read_text(char *,int *);
	int write_text(char *,int ll = -1);
	int read_until_cr(char *,int);
	void echo_on();
	void echo_off();
	int get_adv();

	THREAD *next;
	ADV *selected;
	EVENT *current_event;
	Parser *p;
	pthread_t thread;
	int socket;
	int running;
	int prompt_shown;
	char login[200];
	char last_print[1024];
	char prompt[200];		// last line of last_print
	char instr[1024];
};


#endif // _THREAD_H
